
//////////////////////////Zombie attack II by Rene Pol aka Realspawn -rp-interactive.nl   09-03-2016////////////////////

#define PRAGMA_PATH "3Dmodels"
#define PRAGMA_PATH "Graphics"
#define PRAGMA_PATH "Scripts"
#define PRAGMA_PATH "Sounds"

function earth_quake()
{
	var shaking_time = 15; // shake the camera for 3 seconds


	while (shaking_time > 0)
	{
		shaking_time -= time_step / 16; // subtract a value of 1 from shaking_time each second
		camera.roll = 3 - random(6); // shake the camera by changing its roll angle, play with the numerical values
		wait (1);
	}
	camera.roll = 0; // the explosion has ended here, so let's reset camera's roll angle
}


BMAP* bullet1_map = "bullet.png"; 

PANEL* bullet1_pan =
{
	bmap = bullet1_map; 
	pos_x = 950;
	pos_y = 500;
	layer = 50;
flags = SHOW;
}

BMAP* scare_map = "scare.png"; 

PANEL* scare_pan =
{
	bmap = scare_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 50;
////flags = SHOW;
}




BMAP* bullet2_map = "bullet.png"; 

PANEL* bullet2_pan =
{
	bmap = bullet2_map; 
	pos_x = 950;
	pos_y = 550;
	layer = 50;
flags = SHOW;
}


BMAP* bullet3_map = "bullet.png"; 

PANEL* bullet3_pan =
{
	bmap = bullet3_map; 
	pos_x = 950;
	pos_y = 600;
	layer = 50;
flags = SHOW;
}


BMAP* bullet4_map = "bullet.png"; 

PANEL* bullet4_pan =
{
	bmap = bullet4_map; 
	pos_x = 950;
	pos_y = 650;
	layer = 50;
flags = SHOW;
}


BMAP* bullet5_map = "bullet.png"; 

PANEL* bullet5_pan =
{
	bmap = bullet5_map; 
	pos_x = 950;
	pos_y = 700;
	layer = 50;
flags = SHOW;
}


ENTITY* bully;
function generate_fog();
var soundtrack_handle;

BMAP* scratch_map = "scratch.png"; 

PANEL* scratch_pan =
{
	bmap = scratch_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 50;

}

BMAP* menu_map = "menu.bmp"; 

PANEL* menu_pan =
{
	bmap = menu_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 150;

}

BMAP* gameover_map = "gameover.bmp"; 

PANEL* gameover_pan =
{
	bmap = gameover_map; 
	pos_x = 0;
	pos_y = 0;
	layer = 150;

}
	SOUND* laugh_snd = "laugh.wav";

function scare_you()
{
	var scare_timer = 1000;
	while(1)
	{
		scare_timer -=3* time_step;
		wait(1);
		if(scare_timer <=0){
			snd_play(laugh_snd,100,0);
			set(scare_pan,SHOW);
			wait(-1);
			reset(scare_pan,SHOW);
			scare_timer = 1000;
		}
	}
}

//SKILL DEFINITIONS/////////////////////////////////////////////////////////////////////////////////////////////////////
#define roll_spd skill[1]
#define angle_rot skill[2]


//***********************************************************************************************************


function sc_bloodparticles()
{
	
	set(my,PASSABLE|FLAG2|TRANSLUCENT); 
	reset(my,DYNAMIC);
	
	my.roll = random(360); 
	my.ambient = 20; 
	my.alpha = random(50)+50; 

	while (my.alpha>0)
	{		
		my.scale_x += 5*time_step; 
		my.scale_y = my.scale_x;
		my.scale_z = my.scale_x;
		
		my.alpha -= 25 * time_step; 
		wait (1);
	}
	ent_remove (my);
}


function bloodEffect()
{
	set(my,INVISIBLE | PASSABLE);
	wait(1);
	var speed = random(6); // speed of emmission
	VECTOR spr_angle;
	set(my,PASSABLE|FLAG2|TRANSLUCENT);
	my.roll = random(360); 
	my.scale_x= random(0.06); my.scale_y=my.scale_x;
	my.ambient = 100; 
	
	// direction of blood
	vec_to_angle(spr_angle, my.angle_rot);
	vec_normalize( spr_angle, 1 );

	while (my.alpha > 0) // now fade the last frame quickly
	{
		my.scale_x += random(0.1)*time_step;
		my.scale_y = my.scale_x; // on both axis
		
		// emit from normal
		my.x +=  speed * time_step* spr_angle.x; 		
		my.y +=  speed * time_step* spr_angle.y;				
		my.z +=  speed * time_step* spr_angle.z;

		my.roll += random(2)*time_step;
		my.alpha -= 5 * time_step;
		
		wait (1);
	}
	ent_remove (my);
}

// decal image
BMAP* decal_img= "blood_decal.tga";

// place decal function
function sc_placedecal_fx(var scale) 
{
	if(you!=NULL){
		PARTICLE* p = ent_decal(you,decal_img,scale+random(scale/2),0); // place a random sized decal at the hit entity 
		p.lifespan = 200;

	}
}


// spawn effects ========================================================================================================================================
function create_hit()
{
	VECTOR point_to, tempNormal;
	vec_set(point_to, vector(10000,0,0)); 
	vec_rotate(point_to, camera.pan);
	vec_add(point_to, camera.x);
	
	// do shot
	if(c_trace(camera.x, point_to, IGNORE_PASSABLE|IGNORE_ME|IGNORE_SPRITES|ACTIVATE_SHOOT|USE_POLYGON|IGNORE_FLAG2|SCAN_TEXTURE)>0)
	{
		// temp effects ent pointer
		ENTITY* tempEnt;
		// temp effect direction pointer
		vec_set(tempNormal,normal);
		
		// create blood streak
		tempEnt = ent_create("blood_point.mdl",bully.x, sc_bloodparticles);	
		vec_scale(tempEnt.scale_x,2);
		vec_to_angle(tempEnt.pan, tempNormal);
		
		// place decal
		sc_placedecal_fx( 8); // size of decal = 8
		
		tempEnt = ent_create("blood_cloud.tga",target.x,bloodEffect);	
		vec_set(tempEnt.angle_rot, tempNormal);
		tempEnt.alpha=100;  tempEnt.roll_spd=1;  tempEnt.scale_x=0.1; tempEnt.scale_y=0.1;
		
		tempEnt = ent_create("blood_particles.tga",target.x,bloodEffect);	
		vec_set(tempEnt.angle_rot, tempNormal);
		tempEnt.alpha=100;   tempEnt.roll_spd=0.1;  tempEnt.scale_x=0.2; tempEnt.scale_y=0.2;
		
		tempEnt = ent_create("blood_particles.tga",target.x,bloodEffect);	
		vec_set(tempEnt.angle_rot, tempNormal);
		tempEnt.alpha=100;   tempEnt.roll_spd=0.1;  tempEnt.scale_x=0.1; tempEnt.scale_y=0.1;
		
		
	}
}

SOUND* deathc_snd = "deathc.wav";
SOUND* pain_snd = "pain.wav";
SOUND* death_snd = "death.wav";
SOUND* attack_snd = "attack.wav";
SOUND* shot_snd = "shot.wav";
SOUND* reload_snd = "reload.wav";


BMAP* crosshair_png = "chair.png";
VECTOR mouse_on_screen;


#define health skill20

function health_indicator()
{
	set (my, PASSABLE | BRIGHT);
	while (you)
	{
		my.ambient =50;
		my.lightrange =50;
		vec_set (my.x, you.x);
		my.z += 60;
		my.scale_x = you.health * 0.1; // skill20 aka "health" stores the health for each entity
		wait (1);
	}
}

var enable_game =0;
var ammo =100;
FONT*	fnt3_pan = "Ariel Black#22b"; 
PANEL* pan_ammo = {digits=10,5,"AMMO : %00.0f",fnt3_pan,1,ammo; 
	layer = 5; //the layer of the panel
	flags = SHOW;green=255; blue=0; red=255;
}

var score =0;
FONT*	fnt3_pan = "Ariel Black#22b"; 
PANEL* pan_score = {digits=200,5,"Score : %00.0f",fnt3_pan,1,score; 
	layer = 5; //the layer of the panel
	flags = SHOW;green=255; blue=0; red=255;
}


var power =100;
FONT*	fnt3_pan = "Ariel Black#22b"; 
PANEL* pan_power = {digits=400,5,"Health : %00.0f",fnt3_pan,1,power; 
	layer = 5; //the layer of the panel
	flags = SHOW;green=255; blue=0; red=255;
}

function begin_game()
{
	if(enable_game ==0){
		power = 100;
		score =0;
		ammo = 5;
			level_load("z-attack.WMB");
				generate_fog();
			wait(-1);
			scare_you();
			reset(gameover_pan,SHOW);
			reset(menu_pan,SHOW);
			return;
	}
}



function main()
{
	video_set(1024,768,0,0);
	set(menu_pan,SHOW);
	level_load("menu.WMB");
	mouse_mode = 4;
	mouse_map =  crosshair_png;
	soundtrack_handle = media_loop("ingame.mp3",NULL,90);

	on_space = begin_game;
	while(1){
		
		vec_set(mouse_on_screen.x, vector(mouse_pos.x+30, mouse_pos.y, 260));
		vec_for_screen(mouse_on_screen.x, camera);
		wait(1);
	}
	
}




function got_hit()
{

	
	if (event_type == EVENT_IMPACT)
	if (you.skill1 == 100) // collided with one of the enemies?
	{
		ent_create("blood_point.mdl",my.x, sc_bloodparticles);	
		ent_create("blood_point.mdl",my.x+10, sc_bloodparticles);	
		wait(1);

		my.skill20 -=25;

	}
	if (event_type == EVENT_ENTITY)
	if (you.skill1 == 100) // collided with one of the enemies?
	{
		ent_create("blood_point.mdl",my.x, sc_bloodparticles);	
		ent_create("blood_point.mdl",my.x+10, sc_bloodparticles);	


		my.skill20 -=25;
		
	}

}


function remove_bullet()
{
	if (event_type == EVENT_IMPACT)
	{
		set(my,INVISIBLE | PASSABLE);
		my.event = NULL;
		///	ent_create("Explosion+16.tga", vector(my.x,my.y,my.z), sprite_played);
		////ent_create("bhole.png", vector(my.x,my.y,my.z), bulleth);`
		
		wait(1);
		ent_remove(me);

	}
	if (event_type == EVENT_BLOCK)
	{
		set(my,INVISIBLE | PASSABLE);
		my.event = NULL;
		///	ent_create("Explosion+16.tga", vector(my.x,my.y,my.z), sprite_played);
		////ent_create("bhole.png", vector(my.x,my.y,my.z), bulleth);

		wait(1);
		ent_remove(me);

	}
	if (event_type == EVENT_ENTITY)
	{
		set(my,INVISIBLE | PASSABLE);
		my.event = NULL;
		///	ent_create("Explosion+16.tga", vector(my.x,my.y,my.z), sprite_played);
		////ent_create("bhole.png", vector(my.x,my.y,my.z), bulleth);

		wait(1);
		ent_remove(me);

	}
	
	
}



function move_object()
{
	VECTOR temp_vec;
	vec_fill(temp_vec.x, 0);
	set(my,SHOW |METAL | BRIGHT );
	wait(1);
	bully = me;
	c_setminmax(my);
	my.emask |= ENABLE_BLOCK |ENABLE_ENTITY | ENABLE_IMPACT;
	my.event = remove_bullet;
	vec_set(temp_vec.x, mouse_on_screen.x);
	vec_sub(temp_vec.x, my.x);
	vec_to_angle(my.pan, temp_vec.x);
	my.skill1 = 100;
	
	while(my.skill1 > 0){
		c_move(my, vector(250 * time_step, 0, 0), nullvector, IGNORE_PASSABLE | IGNORE_PASSABLE);
		if(vec_dist(my.x, camera.x) > 2200){ my.skill1 = -1; }
		wait(1);
	}	
	ptr_remove(me);
}

function shoot_object()
{
	
	if(ammo >=1 ){

		snd_play(shot_snd,100,0);
		ent_create("bullet.mdl", vector(camera.x,camera.y,camera.z), move_object);
		ammo -=1;
		wait(1);
		if(ammo ==5){
			set(bullet1_pan,SHOW);
			set(bullet2_pan,SHOW);
			set(bullet3_pan,SHOW);
			set(bullet4_pan,SHOW);
			set(bullet5_pan,SHOW);
		}
		if(ammo ==4){
			reset(bullet1_pan,SHOW);
			set(bullet2_pan,SHOW);
			set(bullet3_pan,SHOW);
			set(bullet4_pan,SHOW);
			set(bullet5_pan,SHOW);
		}
		if(ammo ==3){
			reset(bullet1_pan,SHOW);
			reset(bullet2_pan,SHOW);
			set(bullet3_pan,SHOW);
			set(bullet4_pan,SHOW);
			set(bullet5_pan,SHOW);
		}
			if(ammo ==2){
			reset(bullet1_pan,SHOW);
			reset(bullet2_pan,SHOW);
			reset(bullet3_pan,SHOW);
			set(bullet4_pan,SHOW);
			set(bullet5_pan,SHOW);
		}
			if(ammo ==1){
			reset(bullet1_pan,SHOW);
			reset(bullet2_pan,SHOW);
			reset(bullet3_pan,SHOW);
			reset(bullet4_pan,SHOW);
			set(bullet5_pan,SHOW);
		}
				if(ammo ==0){
			reset(bullet1_pan,SHOW);
			reset(bullet2_pan,SHOW);
			reset(bullet3_pan,SHOW);
			reset(bullet4_pan,SHOW);
			reset(bullet5_pan,SHOW);
		}
	}	
	else
	{
		///	set(reload_pan,SHOW);

	}
}

function reload()
{
	if(ammo ==0){
		ammo = 5;
			snd_play(reload_snd,100,0);
				set(bullet1_pan,SHOW);
			set(bullet2_pan,SHOW);
			set(bullet3_pan,SHOW);
			set(bullet4_pan,SHOW);
			set(bullet5_pan,SHOW);
		return;
	}
}


ENTITY* zombie;

action walking_dead()
{
	zombie = me;
	my.pan =-90;
	set(my,SHADOW | POLYGON | TRANSLUCENT);
	my.alpha = 0;
	c_setminmax(me);
	var walk_percentage =0;
	var death_percentage =0;
	my.health = 100;
	my.emask |= (ENABLE_ENTITY | ENABLE_IMPACT | ENABLE_BLOCK);
	my.event = got_hit;
	on_mouse_left=  shoot_object;
	on_mouse_right = reload;

	ent_create ("health.pcx", nullvector, health_indicator);
	while(my.skill20 >0)
	{
		if(my.y <=-500){
			my.skill20 =0;
			set(scratch_pan,SHOW);
			earth_quake();
			snd_play(attack_snd,100,0);
			wait(-0.2);
			reset(scratch_pan,SHOW);
			ent_remove(me);
			power -=10;
				snd_play(pain_snd,100,0);
			if(power <=0){
			snd_play(deathc_snd,100,0);	
			camera.roll = 90;
			wait(-2);
			set(gameover_pan,SHOW);
			level_load("menu.WMB");
			enable_game = 0;
			
			break;
		}
		
			return;
		}
		my.alpha +=5*time_step;
		walk_percentage %= 100;
		walk_percentage += 4 * time_step;
		ent_animate(my, "walk", walk_percentage, ANM_CYCLE);
		
		c_move(my, vector(4 * time_step, 0, 0), nullvector, GLIDE | IGNORE_PASSABLE | IGNORE_SPRITES);
		wait(1);
		if(my.alpha >=100){
			reset(my,TRANSLUCENT);
		}
		while(my.skill20 <=0){
			set(my,TRANSLUCENT | PASSABLE);
			
			ent_animate(my, "death", death_percentage, 0); // "death" one-shot   animation
			death_percentage += 5 * time_step; // 2 = animation speed for "death"


			
			my.alpha -=15*time_step;
			wait(1);
			if(my.alpha <=0){
				set(my,INVISIBLE | PASSABLE);
				my.event = NULL;
				snd_play(death_snd,100,0);
				
				wait(1);
				ent_remove(me);
				score +=1;
				return;
			}
			

		}	
	}
}




var zombie_timer = 100;

action zombie_spawner()

{
	set(my,PASSABLE | INVISIBLE);
	VECTOR init_pos;
	vec_set(init_pos.x, my.x);

	while (1)
	{
		zombie_timer -=2*time_step;
		// 10 sets the speed of the car
		c_move (my, vector (5 * time_step, 0, 0), nullvector, IGNORE_PASSABLE | GLIDE);
		// the car has move 2000 quants away from the starting point? (play with 2000)
		if (vec_dist (my.x, init_pos.x) > 450)
		vec_set(my.x, init_pos.x); // then teleport it at its starting point
		wait (1);
		if(zombie_timer <=0){

			ent_create("zombie.mdl", vector(my.x,my.y,my.z), walking_dead);
			zombie_timer = 70;
		}
	}
}

////////////////////////////fog/////////////////////////////////////////////////////////////////////////

#define max_alpha skill1
#define max_fog 150

var cam_fog = 50; // needs to be a variable so it can get closer and further away to the camera as needed
VECTOR wind;

void set_alpha() 
{
	var fade_speed = 0.5;
	// fade model in
	my.alpha=90;
	my.max_alpha = integer(random(30));
	if(my.max_alpha < 10){ my.max_alpha = 25; }
	
	while(my.alpha < my.max_alpha)
	{
		my.alpha += fade_speed*time_step;
		wait(1);
	}
	my.alpha = my.max_alpha;
}

void fog_wind()
{
	while(1)
	{
		// new wind direction...
		vec_set(wind.x, vector((random(1) - .5)*1.5, (random(1) - .5)*1.5, random(1)*.4));
		wait(-5 + random(3));
	}
}

void move_fog()
{
	var roll_speed;
	var fade_distance = cam_fog+(cam_fog/6);
	var fog_speed = 20;
	
	roll_speed = random(2)-1; 
	
	while(me)
	{
		my.roll += roll_speed*time_step; //roll this sprite
		
		// update position globally
		c_move(my, nullvector, vector(random(fog_speed)*wind.x*time_step, random(fog_speed)*wind.y*time_step, 0), IGNORE_PASSABLE);
		
		// fade sprite when close to camera
		if(vec_dist(my.x, camera.x) < fade_distance) 
		{
			my.alpha = minv(my.max_alpha, vec_dist(camera.x, my.x) * my.max_alpha / fade_distance);
		}
		
		wait(1);
	}
}

void autofog()
{
	VECTOR cam_pos;
	var randint;
	
	vec_scale(my.scale_x, 0.8);
	set(my, PASSABLE | TRANSLUCENT); // can add BRIGHT, but slows FPS down
	
	//fade in slowly
	set_alpha();
	move_fog();
	
	while(me)
	{
		if(my.alpha < my.max_alpha) { my.alpha += time_step; }
		
		vec_set(cam_pos, camera.x);
		cam_pos.z = my.z;
		
		if(vec_dist(my.x, cam_pos) >= cam_fog)
		{
			// fade the fog out
			while(my.alpha > 0) { my.alpha -= time_step; wait(1); }
			
			// set on new position at edge of fog distance
			vec_set(my.x, vector(cycle(my.x, camera.x - cam_fog, camera.x + cam_fog), cycle(my.y, camera.y - cam_fog, camera.y + cam_fog), camera.z - random(100) + random (200)));
		}
		
		wait(5);
	}
}

void generate_fog()
{
	var randint; // random fog sprite
	var fogcount;
	
	VECTOR pos_place;
	
	fog_wind(); // sets a random fog position every so often
	
	for(fogcount=0; fogcount<max_fog; fogcount++)
	{
		// set random position around camera
		vec_set(pos_place.x, vector(((camera.x - random(cam_fog)) + (camera.x + random(cam_fog))), ((camera.y - random(cam_fog)) + (camera.y + random(cam_fog))), ((camera.z - random(cam_fog/4)) + random(cam_fog/2))));
		//		vec_set(pos_place.x, nullvector);
		
		// get a random number
		randint = integer(random(2));
		// create different fog, based on random number
		if(randint == 0){ ent_create("Dust_1.tga", pos_place, autofog); }
		if(randint == 1){ ent_create("Dust_2.tga", pos_place, autofog); }
	}
}

